<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Connexion Administration - Chidra Production</title>
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Outfit:wght@700;900&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #10b981;
            --primary-dark: #059669;
            --bg-dark: #0f172a;
            --bg-card: #1e293b;
            --text-light: #f8fafc;
            --text-gray: #94a3b8;
        }

        body {
            background-color: var(--bg-dark);
            font-family: 'Inter', sans-serif;
            color: var(--text-light);
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            margin: 0;
            background-image: radial-gradient(circle at top right, rgba(16, 185, 129, 0.1), transparent 40%);
        }

        .login-card {
            background-color: var(--bg-card);
            padding: 2.5rem;
            border-radius: 1rem;
            width: 100%;
            max-width: 400px;
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.5);
            border: 1px solid rgba(255, 255, 255, 0.05);
        }

        .brand {
            text-align: center;
            margin-bottom: 2rem;
        }

        .brand h1 {
            font-family: 'Outfit', sans-serif;
            font-size: 1.5rem;
            margin: 0;
            background: linear-gradient(to right, #fff, var(--text-gray));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .form-group {
            margin-bottom: 1.5rem;
        }

        .form-label {
            display: block;
            margin-bottom: 0.5rem;
            font-size: 0.875rem;
            color: var(--text-gray);
        }

        .form-input {
            width: 100%;
            padding: 0.75rem 1rem;
            background-color: rgba(0, 0, 0, 0.2);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 0.5rem;
            color: white;
            font-family: inherit;
            box-sizing: border-box; /* Important for width: 100% */
            transition: border-color 0.2s;
        }

        .form-input:focus {
            outline: none;
            border-color: var(--primary);
        }

        .btn {
            width: 100%;
            padding: 0.75rem;
            background: linear-gradient(135deg, var(--primary), var(--primary-dark));
            color: white;
            border: none;
            border-radius: 0.5rem;
            font-weight: 600;
            cursor: pointer;
            transition: transform 0.1s;
        }

        .btn:hover {
            transform: translateY(-1px);
        }
        
        .error-msg {
            background: rgba(239, 68, 68, 0.1);
            color: #ef4444;
            padding: 0.75rem;
            border-radius: 0.5rem;
            margin-bottom: 1rem;
            font-size: 0.875rem;
            text-align: center;
            border: 1px solid rgba(239, 68, 68, 0.2);
        }
    </style>
</head>
<body>

    <div class="login-card">
        <div class="brand">
            <h1>Espace Admin</h1>
        </div>

        <?php
        session_start();
        // SIMPLE HARDCODED CREDENTIALS FOR DEMO - CHANGE FOR PRODUCTION
        $ADMIN_USER = 'admin';
        $ADMIN_PASS = 'admin123';

        if (isset($_POST['login'])) {
            $user = $_POST['username'];
            $pass = $_POST['password'];

            if ($user === $ADMIN_USER && $pass === $ADMIN_PASS) {
                $_SESSION['admin_logged_in'] = true;
                header("Location: index.php");
                exit;
            } else {
                echo '<div class="error-msg">Identifiants incorrects</div>';
            }
        }
        ?>

        <form method="POST">
            <div class="form-group">
                <label class="form-label">Identifiant</label>
                <input type="text" name="username" class="form-input" required autofocus>
            </div>
            
            <div class="form-group">
                <label class="form-label">Mot de passe</label>
                <input type="password" name="password" class="form-input" required>
            </div>

            <button type="submit" name="login" class="btn">Se Connecter</button>
        </form>
    </div>

</body>
</html>
