<?php
session_start();
if (!isset($_SESSION['admin_logged_in'])) { header("Location: login.php"); exit; }

$CURRENT_PAGE = 'dashboard';
require_once "header.php";
$pdo = getDB();

// Stats
$quotesCount = $pdo->query("SELECT COUNT(*) FROM quotes")->fetchColumn();
$clientsCount = $pdo->query("SELECT COUNT(*) FROM clients")->fetchColumn();
$recentQuotes = $pdo->query("SELECT * FROM quotes ORDER BY created_at DESC LIMIT 5")->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="page-header">
    <h1 class="page-title">Tableau de Bord</h1>
    <div style="font-size: 0.9rem; color: var(--text-muted);"><?= date('l, d F Y') ?></div>
</div>

<!-- Stats Grid -->
<div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(240px, 1fr)); gap: 1.5rem; margin-bottom: 2rem;">
    <!-- Stat Card 1 -->
    <div class="card" style="display: flex; align-items: center; gap: 1.5rem;">
        <div style="width: 50px; height: 50px; border-radius: 12px; background: rgba(16, 185, 129, 0.2); color: var(--primary); display: flex; align-items: center; justify-content: center; font-size: 1.5rem;">
            <i class="ph ph-file-text"></i>
        </div>
        <div>
            <div style="font-size: 2rem; font-weight: 700; line-height: 1;"><?= $quotesCount ?></div>
            <div style="color: var(--text-muted); font-size: 0.9rem; margin-top: 4px;">Devis reçus</div>
        </div>
    </div>
    
    <!-- Stat Card 2 -->
    <div class="card" style="display: flex; align-items: center; gap: 1.5rem;">
        <div style="width: 50px; height: 50px; border-radius: 12px; background: rgba(99, 102, 241, 0.2); color: var(--secondary); display: flex; align-items: center; justify-content: center; font-size: 1.5rem;">
            <i class="ph ph-users"></i>
        </div>
        <div>
            <div style="font-size: 2rem; font-weight: 700; line-height: 1;"><?= $clientsCount ?></div>
            <div style="color: var(--text-muted); font-size: 0.9rem; margin-top: 4px;">Clients</div>
        </div>
    </div>
    
    <!-- Stat Card 3 -->
    <div class="card" style="display: flex; align-items: center; gap: 1.5rem;">
        <div style="width: 50px; height: 50px; border-radius: 12px; background: rgba(245, 158, 11, 0.2); color: #fbbf24; display: flex; align-items: center; justify-content: center; font-size: 1.5rem;">
            <i class="ph ph-currency-eur"></i>
        </div>
        <div>
            <div style="font-size: 2rem; font-weight: 700; line-height: 1;">0 €</div>
            <div style="color: var(--text-muted); font-size: 0.9rem; margin-top: 4px;">Chiffre d'affaires</div>
        </div>
    </div>
</div>

<!-- Recent Activity -->
<h2 style="font-family: 'Outfit'; font-size: 1.5rem; margin-bottom: 1rem;">Demandes Récentes</h2>
<div class="card">
    <table class="modern-table">
        <thead>
            <tr>
                <th>Date</th>
                <th>Client</th>
                <th>Lieu</th>
                <th>Statut</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($recentQuotes as $quote): ?>
                <tr>
                    <td><?= date('d/m/Y', strtotime($quote['created_at'])) ?></td>
                    <td>
                        <div style="font-weight: 600;"><?= htmlspecialchars($quote['name']) ?></div>
                        <div style="font-size: 0.8rem; color: var(--text-muted);"><?= htmlspecialchars($quote['phone']) ?></div>
                    </td>
                    <td><?= htmlspecialchars($quote['place']) ?></td>
                    <td>
                        <span class="status-badge status-new">Nouveau</span>
                    </td>
                    <td>
                        <button class="btn btn-outline" style="padding: 0.5rem;"><i class="ph ph-eye"></i></button>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php require_once "footer.php"; ?>
