<?php
// Function to get DB connection
function getDB() {
    $host = 'localhost';
    $username = 'root';
    $password = '';
    $dbname = 'rachid_website';
    try {
        $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        return $pdo;
    } catch(PDOException $e) {
        die("DB Connection Error: " . $e->getMessage());
    }
}

// Global Design Variables for Admin
$theme_colors = [
    'primary' => '#10b981', // Emerald 500
    'primary_dark' => '#059669',
    'secondary' => '#6366f1', // Indigo 500
    'bg' => '#0f172a', // Slate 900
    'card' => '#1e293b', // Slate 800
    'text' => '#f8fafc',
    'text_muted' => '#94a3b8'
];
?>
<!DOCTYPE html>
<html lang="fr" class="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin - Chidra Production</title>
    
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&family=Outfit:wght@500;700;800&display=swap" rel="stylesheet">
    
    <!-- Icons (Phosphor Icons for modern look) -->
    <script src="https://unpkg.com/@phosphor-icons/web"></script>

    <!-- Alpine.js -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.13.3/dist/cdn.min.js"></script>

    <style>
        :root {
            --primary: <?= $theme_colors['primary'] ?>;
            --primary-dark: <?= $theme_colors['primary_dark'] ?>;
            --secondary: <?= $theme_colors['secondary'] ?>;
            --bg: <?= $theme_colors['bg'] ?>;
            --card: <?= $theme_colors['card'] ?>;
            --text: <?= $theme_colors['text'] ?>;
            --text-muted: <?= $theme_colors['text_muted'] ?>;
            --sidebar-width: 260px;
        }

        * { box-sizing: border-box; }

        body {
            background-color: var(--bg);
            color: var(--text);
            font-family: 'Inter', sans-serif;
            margin: 0;
            display: flex;
            min-height: 100vh;
        }

        /* Sidebar */
        .sidebar {
            width: var(--sidebar-width);
            background: rgba(30, 41, 59, 0.5);
            border-right: 1px solid rgba(255,255,255,0.05);
            backdrop-filter: blur(10px);
            padding: 1.5rem;
            display: flex;
            flex-direction: column;
            position: fixed;
            height: 100vh;
        }

        .logo {
            font-family: 'Outfit', sans-serif;
            font-size: 1.5rem;
            font-weight: 800;
            margin-bottom: 2.5rem;
            background: linear-gradient(to right, #fff, var(--text-muted));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .nav-item {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 0.85rem 1rem;
            color: var(--text-muted);
            text-decoration: none;
            border-radius: 0.75rem;
            transition: all 0.2s;
            margin-bottom: 0.5rem;
            font-weight: 500;
        }

        .nav-item:hover, .nav-item.active {
            background: rgba(16, 185, 129, 0.1);
            color: var(--primary);
        }
        
        .nav-item i { font-size: 1.25rem; }

        /* Main Content */
        .main-content {
            flex: 1;
            margin-left: var(--sidebar-width);
            padding: 2rem;
            max-width: 1600px;
        }

        .page-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 2rem;
        }

        .page-title {
            font-family: 'Outfit', sans-serif;
            font-size: 2rem;
            margin: 0;
        }

        /* Modern Cards */
        .card {
            background: var(--card);
            border-radius: 1rem;
            border: 1px solid rgba(255,255,255,0.05);
            padding: 1.5rem;
            box-shadow: 0 4px 6px -1px rgba(0,0,0,0.1);
        }

        .btn {
            background: var(--primary);
            color: white;
            border: none;
            padding: 0.75rem 1.5rem;
            border-radius: 0.5rem;
            font-weight: 600;
            cursor: pointer;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            transition: transform 0.1s;
            text-decoration: none;
        }

        .btn:hover { transform: translateY(-1px); filter: brightness(110%); }
        .btn-outline { background: transparent; border: 1px solid var(--text-muted); }
        .btn-danger { background: #ef4444; }

        /* Tables */
        .modern-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 1rem;
        }
        
        .modern-table th {
            text-align: left;
            padding: 1rem;
            color: var(--text-muted);
            font-size: 0.8rem;
            text-transform: uppercase;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        
        .modern-table td {
            padding: 1rem;
            border-bottom: 1px solid rgba(255,255,255,0.05);
        }
        
        .status-badge {
            padding: 0.35rem 0.75rem;
            border-radius: 99px;
            font-size: 0.75rem;
            font-weight: 700;
            text-transform: uppercase;
        }
        
        .status-new { background: rgba(59, 130, 246, 0.2); color: #60a5fa; }
        .status-paid { background: rgba(16, 185, 129, 0.2); color: #34d399; }
        .status-pending { background: rgba(245, 158, 11, 0.2); color: #fbbf24; }

        /* Inputs */
        .input-dark {
            background: rgba(0,0,0,0.2);
            border: 1px solid rgba(255,255,255,0.1);
            color: white;
            padding: 0.75rem;
            border-radius: 0.5rem;
            width: 100%;
            font-family: inherit;
        }
        
        .input-dark:focus { outline: none; border-color: var(--primary); }

    </style>
</head>
<body>

<aside class="sidebar">
    <div class="logo">
        <i class="ph ph-aperture" style="color:var(--primary)"></i> CHIDRAPROD
    </div>
    
    <nav>
        <a href="index.php" class="nav-item <?= $CURRENT_PAGE == 'dashboard' ? 'active' : '' ?>">
            <i class="ph ph-squares-four"></i> Tableau de bord
        </a>
        <a href="quotes.php" class="nav-item <?= $CURRENT_PAGE == 'quotes' ? 'active' : '' ?>">
            <i class="ph ph-file-text"></i> Devis
        </a>
        <a href="invoices.php" class="nav-item <?= $CURRENT_PAGE == 'invoices' ? 'active' : '' ?>">
            <i class="ph ph-currency-eur"></i> Factures
        </a>
        <a href="clients.php" class="nav-item <?= $CURRENT_PAGE == 'clients' ? 'active' : '' ?>">
            <i class="ph ph-users"></i> Clients
        </a>
        <div style="margin-top: 2rem; border-top: 1px solid rgba(255,255,255,0.1); padding-top: 1rem;">
            <a href="logout.php" class="nav-item">
                <i class="ph ph-sign-out"></i> Déconnexion
            </a>
        </div>
    </nav>
</aside>

<main class="main-content">
