<?php
session_start();
if (!isset($_SESSION['admin_logged_in'])) { header("Location: login.php"); exit; }

$CURRENT_PAGE = 'clients';
require_once "header.php";

$pdo = getDB();

// Handle Form Submission (Add/Edit Client)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    if ($_POST['action'] === 'create') {
        $stmt = $pdo->prepare("INSERT INTO clients (name, email, phone, address) VALUES (?, ?, ?, ?)");
        $stmt->execute([$_POST['name'], $_POST['email'], $_POST['phone'], $_POST['address']]);
    }
    // Refresh to avoid resubmit
    echo "<script>window.location.href='clients.php';</script>";
}

// Fetch Clients
$stmt = $pdo->query("SELECT * FROM clients ORDER BY created_at DESC");
$clients = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="page-header">
    <h1 class="page-title">Gestion des Clients</h1>
    <button @click="showModal = true" class="btn">
        <i class="ph ph-plus"></i> Nouveau Client
    </button>
</div>

<div class="card" x-data="{ showModal: false, search: '' }">
    
    <!-- Search Bar -->
    <div style="margin-bottom: 1.5rem; position: relative;">
        <i class="ph ph-magnifying-glass" style="position: absolute; left: 1rem; top: 0.9rem; color: var(--text-muted);"></i>
        <input type="text" x-model="search" placeholder="Rechercher un client..." class="input-dark" style="padding-left: 2.5rem;">
    </div>

    <!-- Clients Table -->
    <table class="modern-table">
        <thead>
            <tr>
                <th>Nom</th>
                <th>Contact</th>
                <th>Localisation</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($clients as $client): ?>
                <tr x-show="search === '' || '<?= strtolower($client['name']) ?>'.includes(search.toLowerCase())">
                    <td>
                        <div style="font-weight: 600; font-size: 1rem;"><?= htmlspecialchars($client['name']) ?></div>
                        <div style="font-size: 0.8rem; color: var(--text-muted);">Ajouté le <?= date('d/m/Y', strtotime($client['created_at'])) ?></div>
                    </td>
                    <td>
                        <div style="display:flex; flex-direction:column; gap:4px;">
                            <span style="display:flex; align-items:center; gap:6px;">
                                <i class="ph ph-envelope-simple"></i> <?= htmlspecialchars($client['email']) ?: 'N/A' ?>
                            </span>
                            <span style="display:flex; align-items:center; gap:6px;">
                                <i class="ph ph-phone"></i> <?= htmlspecialchars($client['phone']) ?: 'N/A' ?>
                            </span>
                        </div>
                    </td>
                    <td><?= htmlspecialchars($client['address']) ?: 'Non renseignée' ?></td>
                    <td>
                        <button class="btn btn-outline" style="padding: 0.5rem;"><i class="ph ph-pencil-simple"></i></button>
                    </td>
                </tr>
            <?php endforeach; ?>
            <?php if (empty($clients)): ?>
                <tr>
                    <td colspan="4" style="text-align: center; padding: 3rem; color: var(--text-muted);">
                        Aucun client trouvé. Ajoutez-en un !
                    </td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <!-- Add Client Modal -->
    <div x-show="showModal" class="fixed inset-0 z-50 flex items-center justify-center bg-black bg-opacity-50" 
         style="position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.8); backdrop-filter: blur(5px); display: none; align-items: center; justify-content: center;"
         x-transition.opacity>
        
        <div class="card" style="width: 100%; max-width: 500px; position: relative;" @click.away="showModal = false">
            <h2 style="margin-top: 0; margin-bottom: 1.5rem;">Nouveau Client</h2>
            
            <form method="POST">
                <input type="hidden" name="action" value="create">
                
                <div style="margin-bottom: 1rem;">
                    <label style="display: block; margin-bottom: 0.5rem; font-size: 0.9rem;">Nom Complet</label>
                    <input type="text" name="name" required class="input-dark">
                </div>
                
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem; margin-bottom: 1rem;">
                    <div>
                        <label style="display: block; margin-bottom: 0.5rem; font-size: 0.9rem;">Email</label>
                        <input type="email" name="email" class="input-dark">
                    </div>
                    <div>
                        <label style="display: block; margin-bottom: 0.5rem; font-size: 0.9rem;">Téléphone</label>
                        <input type="text" name="phone" class="input-dark">
                    </div>
                </div>
                
                <div style="margin-bottom: 1.5rem;">
                    <label style="display: block; margin-bottom: 0.5rem; font-size: 0.9rem;">Adresse</label>
                    <textarea name="address" rows="3" class="input-dark"></textarea>
                </div>
                
                <div style="display: flex; justify-content: flex-end; gap: 1rem;">
                    <button type="button" @click="showModal = false" class="btn btn-outline">Annuler</button>
                    <button type="submit" class="btn">Enregistrer</button>
                </div>
            </form>
        </div>
    </div>

</div>

<?php require_once "footer.php"; ?>
